<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyTextIndent, li.MsoBodyTextIndent, div.MsoBodyTextIndent
  {
  margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:14.2pt;
  margin-bottom:.0001pt;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.RetraitcorpsdetexteCar
  {
  
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">A12RECINV</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr>
                           <td width="88.8%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                           </td>
                           <td width="11.2%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II</span></b></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="88.8%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">RECETTES D’INVESTISSEMENT – VUE D’ENSEMBLE</span></b></p>
                              
                           </td>
                           <td width="11.2%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">A1.2</span></b></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='R') and (not(./n:Fonction/@V))]"/>
                        <thead>
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              <td width="7.3%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="38.3%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="14.1%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"/>
                           </tr>
                           
                           <tr>
                              <td width="7.3%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Chapitre</span></b></p>
                                 
                              </td>
                              <td width="38.3%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Intitulé </span></b></p>
                                 
                              </td>
                              <td width="14.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Prévisions (a)</span></b></p>
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(BP + DM + RAR N-1)</span></b></p>
                                 
                              </td>
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Réalisations</span></b></p>
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">(titres émis) (b)</span></b></p>
                                 
                              </td>
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Taux de réalisation (b/a)</span></b></p>
                                 
                              </td>
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Restes à réaliser au 31/12 (1)</span></b></p>
                                 
                              </td>
                           </tr>
                           
                        </thead>
                        <tr><xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='018') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">018</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '018' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm3" select="$varOdm1[(n:ChapitreNature/@V='13') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">13</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm4" select="$varOdm1[(n:ChapitreNature/@V='16') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">16</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='20') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">20</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"/> (sauf 204)</span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm6" select="$varOdm1[(n:ChapitreNature/@V='204') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">204</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '204' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm7" select="$varOdm1[(n:ChapitreNature/@V='21') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">21</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreNature/@V='22') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">22</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm9" select="$varOdm1[(n:ChapitreNature/@V='23') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">23</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm10" select="$varOdm1[(n:ChapitreNature/@V='10') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">10</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '10' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreNature/@V='18') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">18</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '18' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm12" select="$varOdm1[(n:ChapitreNature/@V='26') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">26</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '26' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm13" select="$varOdm1[(n:ChapitreNature/@V='27') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">27</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '27' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm14" select="$varOdm1[(n:ChapitreNature/@V='024') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">024</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '024' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm14/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                        </tr>
                        <tr style="height:34.9pt">
                           <td width="7.3%" valign="top" style="border:solid black 1.0pt; border-left:double black 1.5pt;padding:0in 3.55pt 0in 3.55pt;height: 34.9pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">45</span></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Chapitres d’opérations pour compte de tiers (2)</span></p>
                              
                           </td>
                           <td width="14.1%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                     and (./n:OpBudg/@V='0')]/n:CredOuv/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                     and (./n:OpBudg/@V='0')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                     and (./n:OpBudg/@V='0')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="45.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes réelles d’investissement</span></b></p>
                              
                           </td>
                           <td width="14.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVREL')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVREL')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVREL')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm15" select="$varOdm1[(n:ChapitreNature/@V='021') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">021</span></i></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '021' and @Type = 'C']/@LibelleCourt)[1])"/> (3)</span></i></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm15/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                        </tr>
                        <tr><xsl:variable name="varOdm16" select="$varOdm1[(n:ChapitreNature/@V='040') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">040</span></i></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '040' and @Type = 'C']/@LibelleCourt)[1])"/> (4) (5) (6)</span></i></p>
                           </td>
                           <td width="14.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm16/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm16/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm16/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                        </tr>
                        <tr><xsl:variable name="varOdm17" select="$varOdm1[(n:ChapitreNature/@V='041') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"/>
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">041</span></i></p>
                              
                           </td>
                           <td width="38.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '041' and @Type = 'C']/@LibelleCourt)[1])"/> (7)</span></i></p>
                           </td>
                           <td width="14.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm17/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm17/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm17/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="45.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes d’ordre en investissement</span></b></p>
                              
                           </td>
                           <td width="14.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVORD')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVORD')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"/></b><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVORD')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="45.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes d’investissement de l’exercice</span></b></p>
                              
                           </td>
                           <td width="14.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:CredOuv/@V"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtReal/@V"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr style="height:19.75pt"><xsl:variable name="varOdm18" select="$varOdm1[(n:ChapitreNature/@V='001') and (./n:OpBudg/@V='T') and (./n:InfoOpe/@V='T')]"/>
                           <td width="45.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 19.75pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">001 Solde d’exécution positif reporté</span></b></p>
                              
                           </td>
                           <td width="14.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm18/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1"> </td>
                        </tr>
                        <tr>
                           <td width="45.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 1.5pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes de la section d’investissement</span></b></p>
                              
                           </td>
                           <td width="14.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTINV')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTINV')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTINV')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="margin-right:46.45pt"><b><span style="font-size:6.0pt; font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) Recettes justifiées non titrées.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(2) Voir l’état IV-B5 pour le détail des opérations pour compte de tiers.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(3) Pour mémoire, crédits ouverts au budget mais ne faisant pas l’objet d’émission de titres (opérations sans réalisation).</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(4) <i>DI 040 = RF 042</i></span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(5) </span><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">Les comptes 15, 29, 39, 49 et 59 peuvent figurer dans le détail du chapitre si la collectivité a opté pour le régime des provisions
                     budgétaires, conformément aux dispositions législatives et réglementaires applicables.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(6) Aucune prévision budgétaire ne doit figurer à l’article 192 (cf. chapitre 024 « produit des cessions d’immobilisations »).</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(7) <i>DI 041 = RI 041</i></span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>